minetest.register_abm({
	nodenames = {"weeping:angel"},
	interval = 1,
	chance = 1,
	action = function(p, node, _, _)
		for _,player in pairs(minetest.env:get_objects_inside_radius(p, 10)) do
			if player:is_player() then
				-- Calculate the vector between the player and the object
				local angle = player_view_angle(p,player)
				
				-- testing purpose
				-- minetest.chat_send_player(player:get_player_name(),"angle: "..angle)
				-- print("angle: "..angle)
				
				local sight = 1 -- sight range
				if angle > sight then -- assume object is in player's blind spot
					local newp = calc_next_step(p,player)
					
					if minetest.pos_to_string(p) ~= minetest.pos_to_string(newp)
					and minetest.pos_to_string(player:getpos()) ~= minetest.pos_to_string(newp) then
						local nopvec = vector.subtract(player:getpos(),newp)
						minetest.remove_node(p)
						minetest.add_node(newp, {name="weeping:angel",param2=minetest.dir_to_facedir({x=-nopvec.x,y=nopvec.y,z=-nopvec.z})})
						
					else
						player:moveto(find_rand_pos(player),false)
						minetest.chat_send_player(player:get_player_name(),"You have been touched by the angel.")
					end
				end
			end
		end
	end,
})